/* Antarmuka dengan Sensor Sidik Jari - Trainer Internet of Things
 * Project : Menghapus sidik jari
 * Created By Electins.id
 * https://www.electins.id | https://www.instagram.com/electins.id/
 */

 // Library Sidik Jari
#include <Adafruit_Fingerprint.h>
// Library LCD 16x2 I2C
#include <Wire.h> 
#include <LiquidCrystal_I2C.h>
// Library Software Serial
#include <SoftwareSerial.h>

// PIN Buzzer terhubung ke PIN D3 NodeMCU
#define BUZZ_PIN  D3

// LCD Objek dengan nama lcd, alamat I2C 0x27, karakter 16x2
LiquidCrystal_I2C lcd(0x27,16,2);

// Koneksi PIN Fingerprint ke PIN NodeMCU
// TX   D5
// RX   D6
// SofwareSerial objek dengan nama FP_Serial
SoftwareSerial FP_Serial(D5, D6);

// Fingerprint Objek dengan nama finger
// dengan koneksi serial FP_Serial
Adafruit_Fingerprint finger = Adafruit_Fingerprint(&FP_Serial);
// Variabel untuk menyimpan ID
int id;

void setup() {
  Serial.begin(115200);
  // Serial Monitor pada baudrate 115200

  // Mengatur BUZZ_PIN sebagai Output
  // Kondisi awal BUZZ_PIN LOW (Buzzer OFF)
  pinMode(BUZZ_PIN, OUTPUT);
  digitalWrite(BUZZ_PIN, LOW);

  // Komunikasi Serial FP dengan baudrate 57600
  finger.begin(57600);
  
  lcd.init();       // Inisialisasi LCD
  lcd.backlight();  // Menyalakan Backlight LCD
  lcd.print("Trainer Kit IoT"); 
  delay(2000);      // Jeda tampilan teks pada LCD
  lcd.clear();      // Membersihkan tampilan LCD

  // Cek koneksi fingerprint
  if(finger.verifyPassword()) {
    lcd.setCursor(0,0); lcd.print("Sensor ditemukan");
    Serial.println("Sensor ditemukan");
    delay(1000);
    lcd.clear();
  }else{
    lcd.setCursor(0,0); lcd.print("Tidak Ada Sensor");
    Serial.println("Tidak Ada Sensor");
    delay(1000);
    lcd.clear();
  }
}

// Membaca angka (ID) dari serial monitor
int baca_id() {
  uint8_t num = 0;
  while (num == 0) {
    while (!Serial.available());
    num = Serial.parseInt();
  }
  buzz_notif();
  return num;
}

void loop() {
  // Mencetak teks ke serial monitor dan LCD 16x2 I2C
  Serial.println("Ketik ID (1-127) yang akan dihapus!");
  lcd.setCursor(0,0); lcd.print("Ketik ID (1-127)");
  lcd.setCursor(0,1); lcd.print(" Serial Monitor ");

  // Memabaca ID
  id = baca_id();
  if (id == 0) {
     return;
  }
  Serial.print("Menghapus ID#");
  Serial.println(id);

  // Menghapus data fingerprint
  // Susuai ID yang dimasukkan
  deleteFingerprint(id);
}

// Fungsi menghapus data sidik jari
uint8_t deleteFingerprint(int id){
  int p = -1;
  p = finger.deleteModel(id);
  if (p == FINGERPRINT_OK) {
    Serial.println("Sidik jari dihapus!");
    buzz_deleted();
    lcd.setCursor(0,0); lcd.print("Berhasil dihapus");
    lcd.setCursor(0,1); lcd.print("................");
    delay(2000);
  }else{
    Serial.println("Sidik jari gagal dihapus");
    buzz_failed();
    lcd.setCursor(0,0); lcd.print("Gagal dihapus   ");
    lcd.setCursor(0,1); lcd.print("................");
    delay(2000);
  }
  return p;
}

// Fungsi Nada Buzzer notif
void buzz_notif(){
  digitalWrite(BUZZ_PIN, HIGH);
  delay(200);
  digitalWrite(BUZZ_PIN, LOW);
  delay(100);
}

// Fungsi Nada Buzzer menghapus data sidik jari  
void buzz_deleted() {
  for (int x = 0; x < 2 ; x++ ) {
    digitalWrite(BUZZ_PIN, HIGH);
    delay(200);
    digitalWrite(BUZZ_PIN, LOW);
    delay(100);
  }
}

// Fungsi Nada Buzzer gagal menghapus data sidik jari  
void buzz_failed() {
  digitalWrite(BUZZ_PIN, HIGH);
  delay(1000);
  digitalWrite(BUZZ_PIN, LOW);
  delay(100);
}
